<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ApplePayAttributes;
use PaypalServerSdkLib\Models\CustomerInformation;
use PaypalServerSdkLib\Models\VaultInstruction;

/**
 * Builder for model ApplePayAttributes
 *
 * @see ApplePayAttributes
 */
class ApplePayAttributesBuilder
{
    /**
     * @var ApplePayAttributes
     */
    private $instance;

    private function __construct(ApplePayAttributes $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new apple pay attributes Builder object.
     */
    public static function init(): self
    {
        return new self(new ApplePayAttributes());
    }

    /**
     * Sets customer field.
     */
    public function customer(?CustomerInformation $value): self
    {
        $this->instance->setCustomer($value);
        return $this;
    }

    /**
     * Sets vault field.
     */
    public function vault(?VaultInstruction $value): self
    {
        $this->instance->setVault($value);
        return $this;
    }

    /**
     * Initializes a new apple pay attributes object.
     */
    public function build(): ApplePayAttributes
    {
        return CoreHelper::clone($this->instance);
    }
}
