<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ApplePayPaymentObject;
use PaypalServerSdkLib\Models\CardResponse;
use PaypalServerSdkLib\Models\GooglePayWalletResponse;
use PaypalServerSdkLib\Models\OrderAuthorizeResponsePaymentSource;
use PaypalServerSdkLib\Models\PaypalWalletResponse;
use PaypalServerSdkLib\Models\VenmoWalletResponse;

/**
 * Builder for model OrderAuthorizeResponsePaymentSource
 *
 * @see OrderAuthorizeResponsePaymentSource
 */
class OrderAuthorizeResponsePaymentSourceBuilder
{
    /**
     * @var OrderAuthorizeResponsePaymentSource
     */
    private $instance;

    private function __construct(OrderAuthorizeResponsePaymentSource $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new order authorize response payment source Builder object.
     */
    public static function init(): self
    {
        return new self(new OrderAuthorizeResponsePaymentSource());
    }

    /**
     * Sets card field.
     */
    public function card(?CardResponse $value): self
    {
        $this->instance->setCard($value);
        return $this;
    }

    /**
     * Sets paypal field.
     */
    public function paypal(?PaypalWalletResponse $value): self
    {
        $this->instance->setPaypal($value);
        return $this;
    }

    /**
     * Sets apple pay field.
     */
    public function applePay(?ApplePayPaymentObject $value): self
    {
        $this->instance->setApplePay($value);
        return $this;
    }

    /**
     * Sets google pay field.
     */
    public function googlePay(?GooglePayWalletResponse $value): self
    {
        $this->instance->setGooglePay($value);
        return $this;
    }

    /**
     * Sets venmo field.
     */
    public function venmo(?VenmoWalletResponse $value): self
    {
        $this->instance->setVenmo($value);
        return $this;
    }

    /**
     * Initializes a new order authorize response payment source object.
     */
    public function build(): OrderAuthorizeResponsePaymentSource
    {
        return CoreHelper::clone($this->instance);
    }
}
